import type React from "react"
import type { Metadata } from "next"
import { Inter } from "next/font/google"
import "./globals.css"

const inter = Inter({ subsets: ["latin"] })

export const metadata: Metadata = {
  title: "SearchGPT - AI-Powered Search Engine",
  description: "Search the web with AI-powered responses using GPT-4o Search Preview. Powered by OpenAI.",
  keywords: ["AI", "search", "GPT-4", "search engine", "artificial intelligence", "OpenAI", "SearchGPT"],
  authors: [{ name: "SearchGPT Team" }],
  viewport: "width=device-width, initial-scale=1",
  icons: {
    icon: "/favicon.ico",
    shortcut: "/favicon.ico",
    apple: "/openai-logo.png",
  },
    generator: 'v0.dev'
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en" className="dark">
      <head>
        <link rel="icon" href="/favicon.ico" sizes="any" />
        <link rel="icon" href="/openai-logo.png" type="image/png" />
        <link rel="apple-touch-icon" href="/openai-logo.png" />
      </head>
      <body className={inter.className}>{children}</body>
    </html>
  )
}
