import Image from "next/image"

export function Header() {
  return (
    <header className="border-b border-gray-800 bg-gray-900/50 backdrop-blur-sm">
      <div className="container mx-auto px-4 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center space-x-4">
            {/* SearchGPT Logo */}
            <div className="relative">
              <Image
                src="/searchgpt-logo.png"
                alt="SearchGPT Logo"
                width={120}
                height={60}
                className="object-contain rounded-xl bg-gray-800/30 p-2 border border-gray-700/50"
                priority
              />
            </div>
          </div>

          <div className="flex items-center space-x-4">
            <div className="flex items-center space-x-2 text-sm text-gray-400">
              <span>Powered by</span>
              <Image
                src="/openai-text.png"
                alt="OpenAI"
                width={60}
                height={20}
                className="object-contain opacity-80 hover:opacity-100 transition-opacity"
              />
            </div>
            <div className="w-px h-6 bg-gray-600" />
            <Image
              src="/openai-logo.png"
              alt="OpenAI Logo"
              width={24}
              height={24}
              className="object-contain opacity-80 hover:opacity-100 transition-opacity"
            />
          </div>
        </div>
      </div>
    </header>
  )
}
