"use client"

import type React from "react"

import { useEffect, useState } from "react"

interface ThemeProviderProps {
  children: React.ReactNode
}

export function ThemeProvider({ children }: ThemeProviderProps) {
  const [mounted, setMounted] = useState(false)

  useEffect(() => {
    setMounted(true)

    // Set dark theme in localStorage
    localStorage.setItem("theme", "dark")
    document.documentElement.classList.add("dark")
  }, [])

  if (!mounted) {
    return null
  }

  return <>{children}</>
}
